program dgparma 
!********************************************************************
! FORTRAN90 code: Example 5.2
! Coded by: Guodong Li and modified by JDG for Example 5.2
! File: example52_size_power.f90
!
! Phi =0 (size); Phi \neq 0 (power)
! Model: SETARMA(2;1,1,1,1) with delay d=2, and theta-lag=1
!
! Reference:
! Li, G. and Li, W.K. (2011)
!   Testing a linear time series model against its threshold extension
!   Biometrika, 98(1), 243-250.
!   DOI: 10.1093/biomet/asq074.
!
! IMSL routines:
!   RNNOR  (Generate pseudorandom numbers from a standard normal 
!           distribution using and inverse CDF methods) 
!   LINDS  (Computes the inverse of a real symmetric positive 
!           definite matrix)
!   EQTIL  (computes empirical quantiles)
!   RNSET  (Initialize a random number seed for use in the IMSL
!           randomnumber generators)
!   RNUN   (Generates pseudorandom numbers from a uniform (0,1)
!           distribution)
!********************************************************************

  USE imsl
  IMPlICIT NONE
  integer,parameter::offset=0,n=251,replication=1,Bootstrap=10000
  integer,parameter:: lda=2,nn=2,ldainv=2,nnf=4,ldaf=4,ldainvf=4 
  integer  i,delay
  integer  iseed,time
  real     a(lda,lda),ainv2(ldainv,ldainv)
  real     af(ldaf,ldaf),ainv2f(ldainvf,ldainvf)    
  real*8   psi1,psi2,phi,sqn,nob
  real*8   innovation((n+offset)*replication),e(n+offset),x(n+offset)
  real*8   y(n),yy(n)
  real*8   theta0(2),fisher(4,4),score(4),ed(n,4),ainv(4,4)
  integer  j,jj,ii,repl
  real*8   ftol,temp0,temp
  real*8   threshold,r,like0,like1,like_temp
  real*8   theta1(4),iter(4),hat_r,hat_theta(4),test_stat,test_stat_try
  integer  maxfcn,error_index
  real*8   invfisher(4,4)
  real*8   dist(Bootstrap*n),diss(n),test_star(bootstrap),fisher0(2,2)
  integer  BB,count,inde(replication)
  real*8   temp1,p_value(replication),aFAC(4,4),det1
  
  external M44INV
  logical  ok_flag
  real*8   results2(3)
  real*8   ttemp(4,replication)
  integer  distribution
  real*8   test_s(replication),test_s1(replication)
  integer  pp,pv, NMISS
  real*8   QPROP(2),Q(2),XLO(2),XHI(2),Q1(2)
  real*8   var1,var2,var3,var22

  iseed=time()
  CALL rnset(iseed)
  call drnnor((n+offset)*replication,innovation)

  distribution=2 ! 0 - uniform; 1 - two points distribution; 2 - normal

do repl=1,replication  ! start "overall loop"
    !******* the start of replication ********

    !*** 1. Setting parameters
    psi1=0.7d0; psi2=0.6d0; phi=0.0d0 
    delay=2.0d0                   ! CHANGE       
    nob=n
    error_index=0

!   *** 2. Generate the sample
!   Used in simulation experiment 1 of Li-Li (2011, Section 4) with ARCH errors
!
!    e(1)=innovation((repl-1)*(n+offset)+1); x(1)=e(1)
    
!    do i=2,n+offset
!       e(i)=innovation((repl-1)*(n+offset)+i)*sqrt(0.5d0+0.5d0*e(i-1)*e(i-1))
!       x(i)=e(i)+psi1*x(i-1)+psi2*e(i-1)
!       if(x(i-1).le.0.0d0) x(i)=x(i)+phi*(psi1*x(i-1)+psi2*e(i-1))
!    end do
    
!    do i=1,n
!       y(i)=x(i+offset)
!    end do


     OPEN(10,file = 'usunemplmnt_first_dif.dat')

     sqn = 1/sqrt(nob)
     temp=0.0d0
 	do i=1,n
     read(10,*) x(i)
 	temp=temp+x(i)
 	end do
     CLOSE(10)
	do i=1,n
	y(i)=x(i)-temp/n
	end do   
    
    yy=y
    qprop=(/0.1d0,0.9d0/)
    CALL dEQTIL (n, y, 2, QPROP, Q, XLO, XHI, NMISS)  ! percentiles
    
    !*** 3. Fit a ARMA(1,1) model without threshold
    ftol=1.0d0; theta0=(/psi1,psi2/)
    maxfcn=0
    
  do while(ftol.gt.1.0d-5)   ! start do while 
       maxfcn=maxfcn+1
       if(maxfcn.gt.200) then
         error_index=1
         go to 555
       end if
       
       e(1)=0.0d0; ed=0.0d0; score=0.0d0; fisher=0.0d0; like0=0.0d0
       
       do i=2,n                                         ! CHANGE
          e(i)=y(i)-theta0(1)*y(i-1)-theta0(2)*e(i-1)   ! CHANGE
	  like0=like0+e(i)*e(i)
          ed(i,1)=-y(i-1)-theta0(2)*ed(i-1,1)           ! CHANGE
	  ed(i,2)=-e(i-1)-theta0(2)*ed(i-1,2)
	
	  do j=1,2
             score(j)=score(j)+e(i)*ed(i,j)
	     do jj=1,2
	        fisher(j,jj)=fisher(j,jj)+ed(i,j)*ed(i,jj)
	     end do
	  end do
       end do
     
       temp0=fisher(1,1)*fisher(2,2)-fisher(1,2)*fisher(1,2)
       temp=fisher(2,2)*score(1)-fisher(1,2)*score(2)
       temp=temp/temp0
       theta0(1)=theta0(1)-temp
       temp=-fisher(1,2)*score(1)+fisher(1,1)*score(2)
       temp=temp/temp0
       theta0(2)=theta0(2)-temp
       
       if(abs(theta0(1)).gt.1.0) theta0(1)=0.0
       if(abs(theta0(2)).gt.1.0) theta0(2)=0.0
       ftol=abs(score(1))+abs(score(2))
!  end of "do while" 
   end do
  
   a(1,1)=fisher(1,1)
   a(1,2)=fisher(1,2)
   a(2,2)=fisher(2,2)
   a(2,1)=fisher(1,2)
   call linds(nn,a,lda,ainv2,ldainv)
   
!  write(*,*) 'f inverse', ainv2(1,1),ainv2(1,2),ainv2(2,2)
!  write(*,*) 'sd ARMA-inv:', sqn*sqrt(ainv2(1,1)),sqn*sqrt(ainv2(2,2))
!  write(*,*) 'Fisher and score'
!  write(*,*) a(1,1),a(1,2),a(2,1),a(2,2),score(1),score(2)
    
  write(*,*) 'ARMA pars: ', theta0(1),theta0(2)
  
  like0=0.0d0; e(1)=0.0d0
  do i=2,n                                        ! CHANGE
     e(i)=y(i)-theta0(1)*y(i-1)-theta0(2)*e(i-1)  ! CHANGE
	like0=like0+e(i)*e(i)
  end do
  var1=like0/dble(n)
  write(*,*) 'variance =', var1
  write(*,*) 'standard error:',sqrt(var1*ainv2(1,1)),sqrt(var1*ainv2(2,2))

!*** 4. Fit a SETARMA(1,1) model
  like1=like0
  
do ii=1,n    ! start "big loop"
   if((y(ii).lt.Q(2)).and.(y(ii).gt.Q(1))) then  ! search through thresholds pars
        r=y(ii)  ! threshold parameter
        ftol=1.0d0; theta1=(/theta0(1),theta0(2),0.0d0,0.0d0/)
        maxfcn=0
        
        do while(ftol.gt.1.0d-5)  ! start "do while loop"
           maxfcn=maxfcn+1
           
           if(maxfcn.gt.200) then
             error_index=1
             go to 555
           end if
   
          e(1)=0.0d0; like_temp=0.0d0; ed=0.0d0; score=0.0d0; fisher=0.0d0
!          e(2)=0.0d0
!          e(3)=0.0d0
!          e(4)=0.0d0
!          e(5)=0.0d0
	  do i=delay+1,n                                    ! CHANGE
	     temp=theta1(2)
	     e(i)=y(i)-theta1(1)*y(i-1)-theta1(2)*e(i-1)    ! CHANGE
	     
	     if(y(i-delay).lt.r) then         ! delay d=2   ! CHANGE
	        temp=temp+theta1(4)
	        e(i)=e(i)-theta1(3)*y(i-1)-theta1(4)*e(i-1) ! CHANGE
	     end if
	     
	     like_temp=like_temp+e(i)*e(i)
	     ed(i,1)=-temp*ed(i-1,1)-y(i-1)                 ! CHANGE 
	     ed(i,2)=-temp*ed(i-1,2)-e(i-1)
	     ed(i,3)=-temp*ed(i-1,3)
	     ed(i,4)=-temp*ed(i-1,4)
	     
	     if(y(i-delay).lt.r) then       ! second regime
	       ed(i,3)=ed(i,3)-y(i-1)       ! CHANGE
	       ed(i,4)=ed(i,4)-e(i-1)
	     end if
	     
             do j=1,4
                score(j)=score(j)+2.0d0*e(i)*ed(i,j)
	        do jj=1,4
	           fisher(j,jj)=fisher(j,jj)+2.0d0*ed(i,j)*ed(i,jj)
	           af(j,jj)=fisher(j,jj)
	        end do
	     end do
          end do      ! end loop i=2,n
         call linds(nnf,af,ldaf,ainv2f,ldainvf)
         call M44INV(fisher,invfisher,ok_flag)
         if(ok_flag.eq..FALSE.) then
            error_index=1
            go to 555
         end if

         do j=1,4
	    iter(j)=0.0d0
	    do jj=1,4
	       iter(j)=iter(j)+invfisher(j,jj)*score(jj)
	    end do
	 end do
	 
	theta1=theta1-iter
        if(abs(theta1(1)).gt.1.0) theta1(1)=0.0
	if(abs(theta1(2)).gt.1.0) theta1(2)=0.0
	if(abs(theta1(3)).gt.1.0) theta1(3)=0.0
	if(abs(theta1(4)).gt.1.0) theta1(4)=0.0
	ftol=abs(score(1))+abs(score(2))+abs(score(3))+abs(score(4))
	
     !! the end of "do while loop"
     end do

     like_temp=0.0d0; e(1)=0.0d0;
     do i=delay+1,n                                     ! CHANGE
	 e(i)=y(i)-theta1(1)*y(i-1)-theta1(2)*e(i-1)    ! CHANGE
	 if(y(i-delay).lt.r) then                       ! second regime
	    e(i)=e(i)-theta1(3)*y(i-1)-theta1(4)*e(i-1) ! CHANGE
	 end if
	 like_temp=like_temp+e(i)*e(i)
     end do

       if(like_temp.lt.like1) then
          like1=like_temp
	  hat_r=r; hat_theta=theta1
!	  write(*,*) 'hat_theta = ',hat_theta,hat_r,like1
       end if
  end if  ! end search through threshold pars (if statement)
! WRITE(*,*) 'SETAR =', theta1(1),theta1(2),theta1(3),theta1(4),hat_r,i
  
end do    ! end "big loop"

!  write(*,*) 'sd ARMA: ', 1/sqrt(fisher(1,1)),1/sqrt(fisher(2,2))

   WRITE(*,*) 'SETAR-final: ',theta1(1),theta1(2),theta1(3),theta1(4),hat_r
!  write(*,*) 'sd SETARMA-inv: ',sqrt(ainv2f(1,1)),sqrt(ainv2f(2,2)),sqrt(ainv2f(3,3)),sqrt(ainv2f(4,4))
!  write(*,*) 'inv Fisher:', sqrt(invfisher(1,1)),sqrt(invfisher(2,2)),sqrt(invfisher(3,3)),sqrt(invfisher(4,4))

!*** 5. The test statistic
! var1=1.0d0
  test_stat=(like0-like1)/var1
  write(*,*) 'test statistic,lik0,lik1,delay: ',test_stat,like0,like1,delay
  var22 = like1/dble(n)
  write(*,*) 'Residual variance (var22) = ', var22
  write(*,*) 'standard errors:',sqrt(var22*ainv2f(1,1)),sqrt(var22*ainv2f(2,2)),sqrt(var22*ainv2f(3,3)),sqrt(var22*ainv2f(4,4))

!*** 6. Using bootstrap to approximate the critical values
  e(1)=0.0d0; 
  
  do i=delay+1,n  ! CHANGE
     ! using true values theta0 if phi=0 (size)  
!!   e(i)=y(i)-theta0(1)*y(i-1)-theta0(2)*e(i-1)              ! CHANGE
     
     ! using estimates of threshold parameters if phi\neq 0 (power)
     e(i)=y(i)-hat_theta(1)*y(i-1)-hat_theta(2)*e(i-1)
 	if(y(i-delay).lt.hat_r) then    ! second regime
 	   e(i)=e(i)-hat_theta(3)*y(i-1)-hat_theta(4)*e(i-1)  ! CHANGE
 	end if
  end do
  
!  y(1)=e(1)   ! generate new ARMA time series with parameters 
!  do i=2,n    ! from SETARMA only in the case phi\neq 0 (power)
!     y(i)=hat_theta(1)*y(i-1)+hat_theta(2)*e(i-1)+e(i)
!  end do

   qprop=(/0.05d0,0.95d0/)
   CALL dEQTIL (n, y, 2, QPROP, Q1, XLO, XHI, NMISS)
   if((Q1(1).gt.Q(1)).or.(Q1(2).lt.Q(2))) then
      error_index=1
      go to 555
   end if
   
!  omi=0.0d0
   i=time()
   call rnset(i)  ! initialize a random seed

   !***** choice of permutation disturb : uniform distribution
   if(distribution.eq.0) then
      call drnun(Bootstrap*n,dist)
      dist=dist-0.5
      dist=2.0*sqrt(3.0)*dist
   end if

!***** choice of the disturb : two points distribution
   if(distribution.eq.1) then
     call drnun(Bootstrap*n,dist)
     dist=dist-0.5
     
     do i=1,Bootstrap*n
       if(dist(i).gt.0.0d0) then
          dist(i)=1.0d0
       else
          dist(i)=-1.0d0
       end if
     end do
   end if

!***** choice of the disturb : standard normal distribution
   if(distribution.eq.2) then
      call drnnor(Bootstrap*n,dist)
   end if

   test_star=-10.0d0; test_stat_try=-10.0d0

   do ii=1,n   ! start "big loop"

      ! start search through threshold parameter r   
      if((y(ii).lt.Q(2)).and.(y(ii).gt.Q(1))) then   
        r=y(ii)
	ed=0.0d0; fisher=0.0d0; score=0.0d0
	
	do i=delay+1,n                         ! CHANGE
	   temp=theta0(2)
	   
!	   if(y(i-delay).lt.r) then
!	     temp=temp+hat_theta(4)
!	   end if

	   ed(i,1)=-temp*ed(i-1,1)-y(i-1)
	   ed(i,2)=-temp*ed(i-1,2)-e(i-1)
	   ed(i,3)=-temp*ed(i-1,3)
	   ed(i,4)=-temp*ed(i-1,4)
	   
	   if(y(i-delay).lt.r) then   ! second regime
	      ed(i,3)=ed(i,3)-y(i-1)  ! CHANGE
	      ed(i,4)=ed(i,4)-e(i-1)
	   end if
	   
           do j=1,4
	      score(j)=score(j)+e(i)*ed(i,j)
	      do jj=1,4
	         fisher(j,jj)=fisher(j,jj)+ed(i,j)*ed(i,jj)
                 af(j,jj)=fisher(j,jj)	         
	      end do
	    end do
       end do  ! end i=2,n
       call linds(nnf,af,ldaf,ainv2f,ldainvf)
       call M44INV(fisher,invfisher,ok_flag)
       
       if(ok_flag.eq..FALSE.) then
          error_index=1
          go to 555
       end if

	temp=fisher(1,1)*fisher(2,2)-fisher(1,2)*fisher(2,1)
	fisher0(1,1)=fisher(2,2)/temp
	fisher0(2,2)=fisher(1,1)/temp
	fisher0(1,2)=-fisher(1,2)/temp
	fisher0(2,1)=fisher0(1,2)
	
 	 !!****************** used for checking program ******
	 temp1=0.0d0
	 
	 do i=1,4
	    do j=1,4
	       temp1=temp1+score(i)*invfisher(i,j)*score(j)
	    end do
	 end do
	 
	 temp=0.0d0
	 
	 do i=1,2
	    do j=1,2
	       temp=temp+score(i)*fisher0(i,j)*score(j)
	    end do
	 end do
	 
	 temp0=temp1-temp
	 if(test_stat_try.lt.temp0) test_stat_try=temp0
	 !!****************** used for checking program ******
	       
	do BB=1,bootstrap  ! start bootstrap replicates
	   var3=0.0d0
	   
           do i=1,n
              diss(i)=dist((BB-1)*n+i)
	      var3=var3+diss(i)*diss(i)
           end do	
           
	   var3=var3/dble(n) ! variance of \varepsilon^[*}_{t}
	   score=0.0d0
	 
	   do i=1,n
	      do j=1,4 
	         score(j)=score(j)+e(i)*ed(i,j)*diss(i)
	      end do
	   end do
	 
	   temp1=0.0d0
	 
	   do i=1,4
	      do j=1,4
	         temp1=temp1+score(i)*invfisher(i,j)*score(j)
	      end do
	   end do
	 
	   temp=0.0d0
	 
	   do i=1,2
	      do j=1,2
	         temp=temp+score(i)*fisher0(i,j)*score(j)
	      end do
	   end do
	 
           var2=like1/dble(n) ! \hat{\sigma}^2_{varepsilon}, like1 from step 4)
	   temp0=(temp1-temp)/(var2*var3)
	   
	   if(test_star(BB).lt.temp0) test_star(BB)=temp0
	   
	end do  ! end bootstrapping loop BB==1,bootstrap
	
! end search for different values of r
  end if
  
  end do  ! end "big loop"  ii=1,n
   
  count=0
  
  do i=1,bootstrap  ! test_stat from step 5)
     if(test_stat.lt.test_star(i)) count=count+1
!    WRITE(*,*) test_stat,test_star(i),i,count     
  end do
  
555  p_value(repl)=dble(count)/dble(bootstrap)
  inde(repl)=error_index
  write(*,*) 'test-statistic, p-value:',test_stat,p_value(repl)
  test_s(repl)=test_stat
  test_s1(repl)=test_stat_try

!******* the end of replication ********
end do  ! end "overall loop" repl=1,replication

! write(*,*) 'sd SETARMA:',1/sqrt(fisher(1,1)),1/sqrt(fisher(2,2)),1/sqrt(fisher(3,3)),1/sqrt(fisher(4,4))
write(*,*) 'sd SETARMA-inv:',sqrt(ainv2f(1,1)),sqrt(ainv2f(2,2)),sqrt(ainv2f(3,3)),sqrt(ainv2f(4,4))

open(10,file='Example52.out')

! do i=1,replication
!   write(10,*) 'index, p-value, test_s, test_s1: '
!   write(10,*) inde(i),p_value(i),test_s(i),test_s1(i)
! end do

pp=0; pv=0
do i=1,replication
   if (inde(i).eq.0) then
      pp=pp+1;
      if(p_value(i).lt.0.05) pv=pv+1
   end if
end do

  temp=dble(pv)/dble(pp)
  write(*,*)" Distribution = ", distribution
  write(*,*)" Phi = ", phi
! write(*,*)" Rejection rate at 5% = ", temp
! write(*,*)" Number of available observations = ", pp

  write(10,*) 
  write(10,*)" Model is: SETARMA(2;1,1,1,1) with delay (d) = ", delay
  write(10,*)" Total number of replications = ",replication 
  write(10,*)" Number of warming-up observations = ", offset
  write(10,*)" Distribution = ", distribution
  write(10,*)" Phi (Phi =0 for level), else power:", phi
! write(10,*)" Rejection rate = ",temp
  write(10,*)" Total number of bootstrap replicates = ", bootstrap
  write(10,*)" Sample size = ", n
  write(10,*)" ARMA pars: ",theta0(1),theta0(2)
  write(10,*)" sd ARMA:", (1/sqrt(fisher(1,1))),(1/sqrt(fisher(2,2)))
  WRITE(10,*)" SETAR-final and hat-r: ", theta1(1),theta1(2),theta1(3),theta1(4),hat_r
  write(10,*)" Test statistic,lik0,lik1,delay:", test_stat,like0,like1,delay
  write(10,*)" Sample variance residuals (var22) = ", var22
  write(10,*)" Standard errors: ", sqrt(var22*ainv2f(1,1)),sqrt(var22*ainv2f(2,2)),sqrt(var22*ainv2f(3,3)),sqrt(var22*ainv2f(4,4))
  write(10,*)" Test-statistic, p-value = ", test_stat,p_value(1)  
! write(10,*)" Number of available observations =", pp
close(10) 

end program dgparma


      SUBROUTINE M44INV (A, AINV, OK_FLAG)

      IMPLICIT NONE

      DOUBLE PRECISION, DIMENSION(4,4), INTENT(IN)  :: A
      DOUBLE PRECISION, DIMENSION(4,4), INTENT(OUT) :: AINV
      LOGICAL, INTENT(OUT) :: OK_FLAG

      DOUBLE PRECISION, PARAMETER :: EPS = 1.0D-10
      DOUBLE PRECISION :: DET
      DOUBLE PRECISION, DIMENSION(4,4) :: COFACTOR


      DET =  A(1,1)*(A(2,2)*(A(3,3)*A(4,4)-A(3,4)*A(4,3))+A(2,3)*(A(3,4)*A(4,2)-A(3,2)*A(4,4))+A(2,4)*(A(3,2)*A(4,3)- &
             A(3,3)*A(4,2)))-A(1,2)*(A(2,1)*(A(3,3)*A(4,4)-A(3,4)*A(4,3))+A(2,3)*(A(3,4)*A(4,1)-A(3,1)*A(4,4))+ &
             A(2,4)*(A(3,1)*A(4,3)-A(3,3)*A(4,1)))+A(1,3)*(A(2,1)*(A(3,2)*A(4,4)-A(3,4)*A(4,2))+A(2,2)*(A(3,4)*A(4,1)- &
             A(3,1)*A(4,4))+A(2,4)*(A(3,1)*A(4,2)-A(3,2)*A(4,1)))-A(1,4)*(A(2,1)*(A(3,2)*A(4,3)-A(3,3)*A(4,2))+ &
             A(2,2)*(A(3,3)*A(4,1)-A(3,1)*A(4,3))+A(2,3)*(A(3,1)*A(4,2)-A(3,2)*A(4,1)))

      IF (ABS(DET) .LE. EPS) THEN
         AINV = 0.0D0
         OK_FLAG = .FALSE.
         RETURN
      END IF

      COFACTOR(1,1) = A(2,2)*(A(3,3)*A(4,4)-A(3,4)*A(4,3))+A(2,3)*(A(3,4)*A(4,2)-A(3,2)*A(4,4))+A(2,4)*(A(3,2)*A(4,3)-A(3,3)*A(4,2))
      COFACTOR(1,2) = A(2,1)*(A(3,4)*A(4,3)-A(3,3)*A(4,4))+A(2,3)*(A(3,1)*A(4,4)-A(3,4)*A(4,1))+A(2,4)*(A(3,3)*A(4,1)-A(3,1)*A(4,3))
      COFACTOR(1,3) = A(2,1)*(A(3,2)*A(4,4)-A(3,4)*A(4,2))+A(2,2)*(A(3,4)*A(4,1)-A(3,1)*A(4,4))+A(2,4)*(A(3,1)*A(4,2)-A(3,2)*A(4,1))
      COFACTOR(1,4) = A(2,1)*(A(3,3)*A(4,2)-A(3,2)*A(4,3))+A(2,2)*(A(3,1)*A(4,3)-A(3,3)*A(4,1))+A(2,3)*(A(3,2)*A(4,1)-A(3,1)*A(4,2))
      COFACTOR(2,1) = A(1,2)*(A(3,4)*A(4,3)-A(3,3)*A(4,4))+A(1,3)*(A(3,2)*A(4,4)-A(3,4)*A(4,2))+A(1,4)*(A(3,3)*A(4,2)-A(3,2)*A(4,3))
      COFACTOR(2,2) = A(1,1)*(A(3,3)*A(4,4)-A(3,4)*A(4,3))+A(1,3)*(A(3,4)*A(4,1)-A(3,1)*A(4,4))+A(1,4)*(A(3,1)*A(4,3)-A(3,3)*A(4,1))
      COFACTOR(2,3) = A(1,1)*(A(3,4)*A(4,2)-A(3,2)*A(4,4))+A(1,2)*(A(3,1)*A(4,4)-A(3,4)*A(4,1))+A(1,4)*(A(3,2)*A(4,1)-A(3,1)*A(4,2))
      COFACTOR(2,4) = A(1,1)*(A(3,2)*A(4,3)-A(3,3)*A(4,2))+A(1,2)*(A(3,3)*A(4,1)-A(3,1)*A(4,3))+A(1,3)*(A(3,1)*A(4,2)-A(3,2)*A(4,1))
      COFACTOR(3,1) = A(1,2)*(A(2,3)*A(4,4)-A(2,4)*A(4,3))+A(1,3)*(A(2,4)*A(4,2)-A(2,2)*A(4,4))+A(1,4)*(A(2,2)*A(4,3)-A(2,3)*A(4,2))
      COFACTOR(3,2) = A(1,1)*(A(2,4)*A(4,3)-A(2,3)*A(4,4))+A(1,3)*(A(2,1)*A(4,4)-A(2,4)*A(4,1))+A(1,4)*(A(2,3)*A(4,1)-A(2,1)*A(4,3))
      COFACTOR(3,3) = A(1,1)*(A(2,2)*A(4,4)-A(2,4)*A(4,2))+A(1,2)*(A(2,4)*A(4,1)-A(2,1)*A(4,4))+A(1,4)*(A(2,1)*A(4,2)-A(2,2)*A(4,1))
      COFACTOR(3,4) = A(1,1)*(A(2,3)*A(4,2)-A(2,2)*A(4,3))+A(1,2)*(A(2,1)*A(4,3)-A(2,3)*A(4,1))+A(1,3)*(A(2,2)*A(4,1)-A(2,1)*A(4,2))
      COFACTOR(4,1) = A(1,2)*(A(2,4)*A(3,3)-A(2,3)*A(3,4))+A(1,3)*(A(2,2)*A(3,4)-A(2,4)*A(3,2))+A(1,4)*(A(2,3)*A(3,2)-A(2,2)*A(3,3))
      COFACTOR(4,2) = A(1,1)*(A(2,3)*A(3,4)-A(2,4)*A(3,3))+A(1,3)*(A(2,4)*A(3,1)-A(2,1)*A(3,4))+A(1,4)*(A(2,1)*A(3,3)-A(2,3)*A(3,1))
      COFACTOR(4,3) = A(1,1)*(A(2,4)*A(3,2)-A(2,2)*A(3,4))+A(1,2)*(A(2,1)*A(3,4)-A(2,4)*A(3,1))+A(1,4)*(A(2,2)*A(3,1)-A(2,1)*A(3,2))
      COFACTOR(4,4) = A(1,1)*(A(2,2)*A(3,3)-A(2,3)*A(3,2))+A(1,2)*(A(2,3)*A(3,1)-A(2,1)*A(3,3))+A(1,3)*(A(2,1)*A(3,2)-A(2,2)*A(3,1))

      AINV = TRANSPOSE(COFACTOR) / DET

      OK_FLAG = .TRUE.

      RETURN

      END SUBROUTINE M44INV

